package demo.mapi.ccv.eu.mapi_demo;

import org.junit.jupiter.api.Test;

import java.util.Arrays;
import java.util.List;

import demo.mapi.ccv.eu.mapi_demo.formatters.OutputFormatter;

public class OutputFormatterTest {

    @SuppressWarnings({"PMD.SystemPrintln", "PMD.JUnitTestsShouldIncludeAssert"})
    @Test
    public void testPrintTicket() {
        OutputFormatter outputFormatter = new OutputFormatter(new OutputFormatter.OutputAppender() {
            @Override
            public void append(String line) {
                System.out.print(line);
            }
        });
        List<String> list = Arrays.asList(
                "C-U-S-T-O-M-E-R R-E-C-E-I-P-T",
                "",
                "",
                "  Card payment CREDITO DE VISA  ",
                "",
                "Amount                119.99 EUR",
                "",
                "26/01/2018                 15:44",
                "Terminal-ID             72250154",
                "TA-No. 000444   Receipt-No. 0211",
                "Card number  ###############3337",
                "Sequence No.                0001",
                "VU-Number        455600000599   ",
                "AID-Parameter         4242424242",
                "Authorization number    00001111",
                "",
                "EMV data:                       ",
                "0040008000/E800////1E0300//90029",
                "0000230300040008000E80001/A81214",
                "             BC/40              ",
                "",
                "",
                "Authorized by X-Host            ",
                "",
                "**          Approved          **");

        outputFormatter.printTicket(list);
    }
}
