package demo.mapi.ccv.eu.mapi_demo.handlers;

import eu.ccvlab.mapi.core.RequestType;
import eu.ccvlab.mapi.core.api.request.CardDetectionRequest;
import eu.ccvlab.mapi.core.api.request.OnlineAgentRequest;
import eu.ccvlab.mapi.core.api.request.TerminalAdministrationOperationType;
import eu.ccvlab.mapi.core.api.request.TerminalCommandRequest;
import eu.ccvlab.mapi.core.api.request.TerminalOperationType;
import eu.ccvlab.mapi.core.payment.Agent;
import eu.ccvlab.mapi.core.payment.Money;
import eu.ccvlab.mapi.core.payment.Payment;
import eu.ccvlab.mapi.core.terminal.ExternalTerminal;

public interface PaymentHandler {
    default void startCardReaderStatus(ExternalTerminal externalTerminal) {
    }


    default void startRefund(ExternalTerminal externalTerminal, Payment.Type type, Money money, Integer referenceNumber) {
    }


    default void startPaymentAfterCardRead(ExternalTerminal externalTerminal, Payment.Type type, Money money) {
    }


    default void startPayment(ExternalTerminal externalTerminal, Payment payment) {
    }

    default void startVoid(ExternalTerminal externalTerminal, Payment.Type type, Money money, String transactionId, RequestType originalRequestType, String token) {
    }

    default void startExternalVoid(ExternalTerminal externalTerminal, Payment payment) {
    }


    default void startInitialisation(ExternalTerminal externalTerminal) {
    }


    default void startCardRead(ExternalTerminal externalTerminal, Money money) {
    }

    default void startCardReadSecureID(ExternalTerminal externalTerminal, Money money) {
    }

    default void getTransactionOverview(ExternalTerminal externalTerminal) {
    }

    default void performPeriodClosing(ExternalTerminal externalTerminal) {
    }

    default void ticketReprintPeriodClosing(ExternalTerminal externalTerminal) {
    }


    default void startStatus(ExternalTerminal externalTerminal) {
    }


    default void startRetrieveLastTicket(ExternalTerminal externalTerminal) {
    }


    default void startRepeatLastMessage(ExternalTerminal externalTerminal) {
    }

    default void startRepeatLastServiceMessage(ExternalTerminal externalTerminal) {
    }


    default void startAbort(ExternalTerminal externalTerminal) {
    }


    default void startAbortOnNewConnection(ExternalTerminal externalTerminal) {
    }


    default void showTerminalMenu(ExternalTerminal externalTerminal) {
    }


    default void startCardReservation(ExternalTerminal externalTerminal, Payment.Type type, Money money) {
    }


    default void startReservationAdjustment(ExternalTerminal externalTerminal, Payment.Type type, Money money, String approvalCode) {
    }

    default void startReservationAdjustmentNoCardPresent(ExternalTerminal externalTerminal, Payment.Type type, Money money, String approvalCode, String token) {}

    default void startSaleAfterReservation(ExternalTerminal externalTerminal, Payment.Type type, Money money, String approvalCode, String token) {
    }

    default void callTMS(ExternalTerminal externalTerminal, String jobName){}


    default void startFactoryReset(ExternalTerminal externalTerminal){}

    default void startServiceMenu(ExternalTerminal externalTerminal){}

    default void oamServerApplications(ExternalTerminal externalTerminal){}

    default void startDiagnosis(ExternalTerminal externalTerminal, TerminalOperationType terminalOperationType){}

    default void startConfigDataRetrieval(ExternalTerminal externalTerminal, TerminalAdministrationOperationType terminalAdministrationOperationType){}

    default void recoverPayment(ExternalTerminal externalTerminal, String paymentRequestId){};

    default void cardCircuits(ExternalTerminal externalTerminal){};

    default void authorisationByVoice(ExternalTerminal externalTerminal, Payment.Type type, Money money,  String voiceReferralAID) {};

    default void terminalCommand(ExternalTerminal externalTerminal, TerminalCommandRequest terminalCommandRequest, Agent agent){};

    default void startReadUID(ExternalTerminal externalTerminal){};
    default void flexo(ExternalTerminal externalTerminal){};
    default void checkPassword(ExternalTerminal externalTerminal){};

    default void startResetToFactorySettings(ExternalTerminal externalTerminal) {};

    default void elmeVersionInfo(ExternalTerminal externalTerminal) {};

    default void giftCardBalance(ExternalTerminal externalTerminal) {};
    default void giftCardActivation(ExternalTerminal externalTerminal, Money amount) {};

    default void activateTerminal(ExternalTerminal externalTerminal) {};

    default void startup(ExternalTerminal externalTerminal) {};

    default void token(ExternalTerminal externalTerminal) {};
    default void startRefundWithToken(ExternalTerminal externalTerminal, Payment.Type type, Money money, String hashData) {};
    default void cardDetection(ExternalTerminal externalTerminal, CardDetectionRequest cardDetectionRequest) {};
    default void silentAbort(ExternalTerminal externalTerminal) {};
    default void onlineAgent(ExternalTerminal externalTerminal, OnlineAgentRequest onlineAgentRequest) {};
    default void login(ExternalTerminal externalTerminal) {};
}
