package demo.mapi.ccv.eu.mapi_demo.activities.attended;

import android.os.Bundle;
import android.text.Html;
import android.text.style.URLSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import demo.mapi.ccv.eu.mapi_demo.AndroidLogger;
import demo.mapi.ccv.eu.mapi_demo.R;
import eu.ccvlab.mapi.core.logging.MPALogging;

public class AttendedCertificationTestsFragment extends Fragment {
    TextView transactionHappyFlow;
    TextView transactionHappyFlowContactless;
    TextView transactionHappyFlowMagneticStripe;
    TextView transactionDeclinedByHost;
    TextView transactionAbortedByCardholder;
    TextView transactionAbsenceOfThousandSeparator;
    TextView transactionCashierDisplayMessages;
    TextView abortingRegularAbortByMerchant;
    TextView abortingFailingAbortByMerchant;
    TextView abortingHammeringAbortByMerchant;
    TextView validationTooManyFingers;
    TextView validationNotRemovingCard;
    TextView validationPowerLossOrClosingOfEcrPosDuringTransaction;
    TextView reprintTicket;
    TextView reprintTicketDeclinedTransaction;
    TextView reprintTicketNoPrinterAvailable;
    TextView reprintTicketDeclinedTransactionNoPrinterAvailable;
    TextView storeEJournal;
    TextView ecrPosPrintJournalReceipts;
    TextView ecrPosStoringJournalReceipts;
    TextView connectionLostManualTransactionRecovery;
    TextView connectionLostEthernetConnectionWithItsFails;
    TextView connectionLostDeviceUnavailable;
    TextView connectionLostTerminalNotResponding;
    TextView timeOutOnPresentingACard;
    TextView timeOutDuringPinEntry;
    TextView allowedAmountsTransactionWithAmountZero;
    TextView allowedAmountsTransactionWithNegativeAmount;
    TextView allowedAmountsTransactionWithHighestPossibleAmount;
    TextView allowedAmountsOverAmountTransaction;
    TextView optionalAutomaticTransactionRecovery;
    TextView optionalRequestForIdentification;
    TextView optionalRequestForSignature;
    TextView optionalRequestForSignatureAndIdentification;
    TextView optionalFailingTransactionNoReceipt;
    TextView optionalSplitPayment;

    public AttendedCertificationTestsFragment(){
        super(R.layout.attended_certification_tests_fragment);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        MPALogging.addLogger(new AndroidLogger("AttendedCertificationTestsWebViewFragment"));
        transactionHappyFlow = view.findViewById(R.id.transaction_happy_flow);
        transactionHappyFlowContactless = view.findViewById(R.id.transaction_happy_flow_contactless);
        transactionHappyFlowMagneticStripe = view.findViewById(R.id.transaction_happy_flow_magnetic_stripe);
        transactionDeclinedByHost = view.findViewById(R.id.transaction_declined_by_host);
        transactionAbortedByCardholder = view.findViewById(R.id.transaction_aborted_by_cardholder);
        transactionAbsenceOfThousandSeparator = view.findViewById(R.id.transaction_absence_of_thousand_separator);
        transactionCashierDisplayMessages = view.findViewById(R.id.transaction_cashier_display_messages);
        abortingRegularAbortByMerchant = view.findViewById(R.id.aborting_regular_abort_by_merchant);
        abortingFailingAbortByMerchant = view.findViewById(R.id.aborting_failing_abort_by_merchant);
        abortingHammeringAbortByMerchant = view.findViewById(R.id.aborting_hammering_abort_by_merchant);
        validationTooManyFingers = view.findViewById(R.id.validation_too_many_fingers);
        validationNotRemovingCard = view.findViewById(R.id.validation_not_removing_card);
        validationPowerLossOrClosingOfEcrPosDuringTransaction = view.findViewById(R.id.validation_power_loss_or_closing_of_ecr_pos_during_transaction);
        reprintTicket = view.findViewById(R.id.reprint_ticket);
        reprintTicketDeclinedTransaction = view.findViewById(R.id.reprint_ticket_declined_transaction);
        reprintTicketNoPrinterAvailable = view.findViewById(R.id.reprint_ticket_no_printer_available);
        reprintTicketDeclinedTransactionNoPrinterAvailable = view.findViewById(R.id.reprint_ticket_declined_transaction_no_printer_available);
        storeEJournal = view.findViewById(R.id.e_journal_store_e_journal);
        ecrPosPrintJournalReceipts = view.findViewById(R.id.e_journal_ecr_pos_print_journal_receipts);
        ecrPosStoringJournalReceipts = view.findViewById(R.id.e_journal_ecr_pos_storing_journal_receipts);
        connectionLostManualTransactionRecovery = view.findViewById(R.id.connection_lost_manual_transaction_recovery);
        connectionLostEthernetConnectionWithItsFails = view.findViewById(R.id.connection_lost_ethernet_connection_with_its_fails);
        connectionLostDeviceUnavailable = view.findViewById(R.id.connection_lost_device_unavailable);
        connectionLostTerminalNotResponding = view.findViewById(R.id.connection_lost_terminal_not_responding);
        timeOutOnPresentingACard = view.findViewById(R.id.time_out_on_presenting_a_card);
        timeOutDuringPinEntry = view.findViewById(R.id.time_out_during_pin_entry);
        allowedAmountsOverAmountTransaction = view.findViewById(R.id.allowed_amounts_over_amount_transaction);
        allowedAmountsTransactionWithAmountZero = view.findViewById(R.id.allowed_amounts_transaction_with_amount_zero);
        allowedAmountsTransactionWithHighestPossibleAmount = view.findViewById(R.id.allowed_amounts_transaction_with_highest_possible_amount);
        allowedAmountsTransactionWithNegativeAmount = view.findViewById(R.id.allowed_amounts_transaction_with_negative_amount);
        optionalAutomaticTransactionRecovery = view.findViewById(R.id.optional_automatic_transaction_recovery);
        optionalSplitPayment = view.findViewById(R.id.optional_split_payment);
        optionalFailingTransactionNoReceipt = view.findViewById(R.id.optional_failing_transaction_no_receipt);
        optionalRequestForSignature = view.findViewById(R.id.optional_request_for_signature);
        optionalRequestForIdentification = view.findViewById(R.id.optional_request_for_identification);
        optionalRequestForSignatureAndIdentification = view.findViewById(R.id.optional_request_for_signature_and_identification);

        transactionHappyFlow.setText(Html.fromHtml(getString(R.string.transaction_happy_flow)));
        transactionHappyFlowContactless.setText(Html.fromHtml(getString(R.string.transaction_happy_flow_contactless)));
        transactionHappyFlowMagneticStripe.setText(Html.fromHtml(getString(R.string.transaction_happy_flow_magnetic_stripe)));
        transactionDeclinedByHost.setText(Html.fromHtml(getString(R.string.transaction_declined_by_host)));
        transactionAbortedByCardholder.setText(Html.fromHtml(getString(R.string.transaction_aborted_by_cardholder)));
        transactionAbsenceOfThousandSeparator.setText(Html.fromHtml(getString(R.string.transaction_absence_of_thousand_separator)));
        transactionCashierDisplayMessages.setText(Html.fromHtml(getString(R.string.transaction_cashier_display_messages)));
        abortingRegularAbortByMerchant.setText(Html.fromHtml(getString(R.string.aborting_regular_abort_by_merchant)));
        abortingFailingAbortByMerchant.setText(Html.fromHtml(getString(R.string.aborting_failing_abort_by_merchant)));
        abortingHammeringAbortByMerchant.setText(Html.fromHtml(getString(R.string.aborting_hammering_abort_by_merchant)));
        validationTooManyFingers.setText(Html.fromHtml(getString(R.string.validation_too_many_fingers)));
        validationNotRemovingCard.setText(Html.fromHtml(getString(R.string.validation_not_removing_card)));
        validationPowerLossOrClosingOfEcrPosDuringTransaction.setText(Html.fromHtml(getString(R.string.validation_power_loss_or_closing_of_ecr_pos_during_transaction)));
        reprintTicket.setText(Html.fromHtml(getString(R.string.reprint_ticket)));
        reprintTicketDeclinedTransaction.setText(Html.fromHtml(getString(R.string.reprint_ticket_declined_transaction)));
        reprintTicketNoPrinterAvailable.setText(Html.fromHtml(getString(R.string.reprint_ticket_no_printer_available)));
        reprintTicketDeclinedTransactionNoPrinterAvailable.setText(Html.fromHtml(getString(R.string.reprint_ticket_declined_transaction_no_printer_available)));
        storeEJournal.setText(Html.fromHtml(getString(R.string.e_journal_store_e_journal)));
        ecrPosPrintJournalReceipts.setText(Html.fromHtml(getString(R.string.e_journal_ecr_pos_print_journal_receipts)));
        ecrPosStoringJournalReceipts.setText(Html.fromHtml(getString(R.string.e_journal_ecr_pos_storing_journal_receipts)));
        connectionLostDeviceUnavailable.setText(Html.fromHtml(getString(R.string.connection_lost_device_unavailable)));
        connectionLostEthernetConnectionWithItsFails.setText(Html.fromHtml(getString(R.string.connection_lost_ethernet_connection_with_its_fails)));
        connectionLostManualTransactionRecovery.setText(Html.fromHtml(getString(R.string.connection_lost_manual_transaction_recovery)));
        connectionLostTerminalNotResponding.setText(Html.fromHtml(getString(R.string.connection_lost_terminal_not_responding)));
        timeOutOnPresentingACard.setText(Html.fromHtml(getString(R.string.time_out_on_presenting_a_card)));
        timeOutDuringPinEntry.setText(Html.fromHtml(getString(R.string.time_out_during_pin_entry)));
        allowedAmountsTransactionWithAmountZero.setText(Html.fromHtml(getString(R.string.allowed_amounts_transaction_with_amount_zero)));
        allowedAmountsTransactionWithNegativeAmount.setText(Html.fromHtml(getString(R.string.allowed_amounts_transaction_with_negative_amount)));
        allowedAmountsTransactionWithHighestPossibleAmount.setText(Html.fromHtml(getString(R.string.allowed_amounts_transaction_with_highest_possible_amount)));
        allowedAmountsOverAmountTransaction.setText(Html.fromHtml(getString(R.string.allowed_amounts_over_amount_transaction)));
        optionalAutomaticTransactionRecovery.setText(Html.fromHtml(getString(R.string.optional_automatic_transaction_recovery)));
        optionalRequestForIdentification.setText(Html.fromHtml(getString(R.string.optional_request_for_identification)));
        optionalRequestForSignature.setText(Html.fromHtml(getString(R.string.optional_request_for_signature)));
        optionalRequestForSignatureAndIdentification.setText(Html.fromHtml(getString(R.string.optional_request_for_signature_and_identification)));
        optionalFailingTransactionNoReceipt.setText(Html.fromHtml(getString(R.string.optional_failing_transaction_no_receipt)));
        optionalSplitPayment.setText(Html.fromHtml(getString(R.string.optional_split_payment)));

        view.findViewById(R.id.transaction_happy_flow).setOnClickListener((View onClickView) -> onClickTransactionHappyFlow());
        view.findViewById(R.id.transaction_happy_flow_contactless).setOnClickListener((View onClickView) -> onClickTransactionHappyFlowContactless());
        view.findViewById(R.id.transaction_happy_flow_magnetic_stripe).setOnClickListener((View onClickView) -> onClickTransactionHappyFlowMagneticStripe());
        view.findViewById(R.id.transaction_declined_by_host).setOnClickListener((View onClickView) -> onClickTransactionDeclinedByHost());
        view.findViewById(R.id.transaction_aborted_by_cardholder).setOnClickListener((View onClickView) -> onClickTransactionAbortedByCardholder());
        view.findViewById(R.id.transaction_absence_of_thousand_separator).setOnClickListener((View onClickView) -> onClickTransactionAbsenceOfThousandSeparator());
        view.findViewById(R.id.transaction_cashier_display_messages).setOnClickListener((View onClickView) -> onClickTransactionCashierDisplayMessages());
        view.findViewById(R.id.aborting_regular_abort_by_merchant).setOnClickListener((View onClickView) -> onClickAbortingRegularAbortBymerchant());
        view.findViewById(R.id.aborting_failing_abort_by_merchant).setOnClickListener((View onClickView) -> onClickAbortingFailingAbortByMerchant());
        view.findViewById(R.id.aborting_hammering_abort_by_merchant).setOnClickListener((View onClickView) -> onClickAbortingHammeringAbortByMerchant());
        view.findViewById(R.id.validation_too_many_fingers).setOnClickListener((View onClickView) -> onClickValidationTooManyFingers());
        view.findViewById(R.id.validation_not_removing_card).setOnClickListener((View onClickView) -> onClickValidationNotRemovingCard());
        view.findViewById(R.id.validation_not_removing_card).setOnClickListener((View onClickView) -> onClickValidationNotRemovingCard());
        view.findViewById(R.id.validation_power_loss_or_closing_of_ecr_pos_during_transaction).setOnClickListener((View onClickView) -> onClickValidationPowerLossOrClosingOfEcrPosDuringTransaction());
        view.findViewById(R.id.reprint_ticket).setOnClickListener((View onClickView) -> onClickReprintTicket());
        view.findViewById(R.id.reprint_ticket_declined_transaction).setOnClickListener((View onClickView) -> onClickReprintTicketDeclinedTransaction());
        view.findViewById(R.id.reprint_ticket_no_printer_available).setOnClickListener((View onClickView) -> onClickReprintTicketNoPrinterAvailable());
        view.findViewById(R.id.reprint_ticket_declined_transaction_no_printer_available).setOnClickListener((View onClickView) -> onClickReprintTicketDeclinedTransactionNoPrinterAvailable());
        view.findViewById(R.id.e_journal_store_e_journal).setOnClickListener((View onClickView) -> onClickEJournalStoreEJournal());
        view.findViewById(R.id.e_journal_ecr_pos_print_journal_receipts).setOnClickListener((View onClickView) -> onClickEJournalEcrPosPrintJournalReceipts());
        view.findViewById(R.id.e_journal_ecr_pos_storing_journal_receipts).setOnClickListener((View onClickView) -> onClickEJournalEcrPosStoringJournalReceipts());
        view.findViewById(R.id.connection_lost_device_unavailable).setOnClickListener((View onClickView) -> onClickConnectionLostDeviceUnavailable());
        view.findViewById(R.id.connection_lost_ethernet_connection_with_its_fails).setOnClickListener((View onClickView) -> onClickConnectionLostEthernetConnectionWithItsFails());
        view.findViewById(R.id.connection_lost_manual_transaction_recovery).setOnClickListener((View onClickView) -> onClickConnectionLostManualTransactionRecovery());
        view.findViewById(R.id.connection_lost_terminal_not_responding).setOnClickListener((View onClickView) -> onClickConnectionLostTerminalNotResponding());
        view.findViewById(R.id.time_out_on_presenting_a_card).setOnClickListener((View onClickView) -> onClickTimeOutOnPresentingACard());
        view.findViewById(R.id.time_out_during_pin_entry).setOnClickListener((View onClickView) -> onClickTimeOutDuringPinEntry());
        view.findViewById(R.id.allowed_amounts_transaction_with_amount_zero).setOnClickListener((View onClickView) -> onClickAllowedAmountsTransactionWithAmountZero());
        view.findViewById(R.id.allowed_amounts_transaction_with_negative_amount).setOnClickListener((View onClickView) -> onClickAllowedAmountsTransactionWithNegativeAmount());
        view.findViewById(R.id.allowed_amounts_transaction_with_highest_possible_amount).setOnClickListener((View onClickView) -> onClickAllowedAmountsTransactionWithHighestPossibleAmount());
        view.findViewById(R.id.allowed_amounts_over_amount_transaction).setOnClickListener((View onClickView) -> onClickAllowedAmountsOverAmountTransaction());
        view.findViewById(R.id.optional_automatic_transaction_recovery).setOnClickListener((View onClickView) -> onClickOptionalAutomaticTransactionRecovery());
        view.findViewById(R.id.optional_request_for_identification).setOnClickListener((View onClickView) -> onClickOptionalRequestForIdentification());
        view.findViewById(R.id.optional_request_for_signature).setOnClickListener((View onClickView) -> onClickOptionalRequestForSignature());
        view.findViewById(R.id.optional_request_for_signature_and_identification).setOnClickListener((View onClickView) -> onClickOptionalRequestForSignatureAndIdentification());
        view.findViewById(R.id.optional_failing_transaction_no_receipt).setOnClickListener((View onClickView) -> onClickOptionalFailingTransactionNoReceipt());
        view.findViewById(R.id.optional_split_payment).setOnClickListener((View onClickView) -> onClickOptionalSplitPayment());

        return view;
    }

    public void onClickTransactionHappyFlow() {
        startWebViewFragment(getString(R.string.transaction_happy_flow));
    }
    public void onClickTransactionHappyFlowContactless() {
        startWebViewFragment(getString(R.string.transaction_happy_flow_contactless));
    }
    public void onClickTransactionHappyFlowMagneticStripe() {
        startWebViewFragment(getString(R.string.transaction_happy_flow_magnetic_stripe));
    }
    public void onClickTransactionDeclinedByHost() {
        startWebViewFragment(getString(R.string.transaction_declined_by_host));
    }
    public void onClickTransactionAbortedByCardholder() {
        startWebViewFragment(getString(R.string.transaction_aborted_by_cardholder));
    }
    public void onClickTransactionAbsenceOfThousandSeparator() {
        startWebViewFragment(getString(R.string.transaction_absence_of_thousand_separator));
    }
    public void onClickTransactionCashierDisplayMessages() {
        startWebViewFragment(getString(R.string.transaction_cashier_display_messages));
    }
    public void onClickAbortingRegularAbortBymerchant() {
        startWebViewFragment(getString(R.string.aborting_regular_abort_by_merchant));
    }
    public void onClickAbortingFailingAbortByMerchant() {
        startWebViewFragment(getString(R.string.aborting_failing_abort_by_merchant));
    }
    public void onClickAbortingHammeringAbortByMerchant() {
        startWebViewFragment(getString(R.string.aborting_hammering_abort_by_merchant));
    }
    public void onClickValidationTooManyFingers() {
        startWebViewFragment(getString(R.string.validation_too_many_fingers));
    }
    public void onClickValidationNotRemovingCard() {
        startWebViewFragment(getString(R.string.validation_not_removing_card));
    }
    public void onClickValidationPowerLossOrClosingOfEcrPosDuringTransaction() {
        startWebViewFragment(getString(R.string.validation_power_loss_or_closing_of_ecr_pos_during_transaction));
    }
    public void onClickReprintTicket() {
        startWebViewFragment(getString(R.string.reprint_ticket));
    }
    public void onClickReprintTicketDeclinedTransaction() {
        startWebViewFragment(getString(R.string.reprint_ticket_declined_transaction));
    }
    public void onClickReprintTicketNoPrinterAvailable() {
        startWebViewFragment(getString(R.string.reprint_ticket_no_printer_available));
    }
    public void onClickReprintTicketDeclinedTransactionNoPrinterAvailable() {
        startWebViewFragment(getString(R.string.reprint_ticket_declined_transaction_no_printer_available));
    }
    public void onClickEJournalStoreEJournal() {
        startWebViewFragment(getString(R.string.e_journal_store_e_journal));
    }
    public void onClickEJournalEcrPosPrintJournalReceipts() {
        startWebViewFragment(getString(R.string.e_journal_ecr_pos_print_journal_receipts));
    }
    public void onClickEJournalEcrPosStoringJournalReceipts() {
        startWebViewFragment(getString(R.string.e_journal_ecr_pos_storing_journal_receipts));
    }
    public void onClickConnectionLostDeviceUnavailable() {
        startWebViewFragment(getString(R.string.connection_lost_device_unavailable));
    }
    public void onClickConnectionLostEthernetConnectionWithItsFails() {
        startWebViewFragment(getString(R.string.connection_lost_ethernet_connection_with_its_fails));
    }
    public void onClickConnectionLostManualTransactionRecovery() {
        startWebViewFragment(getString(R.string.connection_lost_manual_transaction_recovery));
    }
    public void onClickConnectionLostTerminalNotResponding() {
        startWebViewFragment(getString(R.string.connection_lost_terminal_not_responding));
    }
    public void onClickTimeOutOnPresentingACard() {
        startWebViewFragment(getString(R.string.time_out_on_presenting_a_card));
    }
    public void onClickTimeOutDuringPinEntry() {
        startWebViewFragment(getString(R.string.time_out_during_pin_entry));
    }
    public void onClickAllowedAmountsTransactionWithAmountZero() {
        startWebViewFragment(getString(R.string.allowed_amounts_transaction_with_amount_zero));
    }
    public void onClickAllowedAmountsTransactionWithNegativeAmount() {
        startWebViewFragment(getString(R.string.allowed_amounts_transaction_with_negative_amount));
    }
    public void onClickAllowedAmountsTransactionWithHighestPossibleAmount() {
        startWebViewFragment(getString(R.string.allowed_amounts_transaction_with_highest_possible_amount));
    }
    public void onClickAllowedAmountsOverAmountTransaction() {
        startWebViewFragment(getString(R.string.allowed_amounts_over_amount_transaction));
    }
    public void onClickOptionalAutomaticTransactionRecovery() {
        startWebViewFragment(getString(R.string.optional_automatic_transaction_recovery));
    }
    public void onClickOptionalRequestForIdentification() {
        startWebViewFragment(getString(R.string.optional_request_for_identification));
    }
    public void onClickOptionalRequestForSignature() {
        startWebViewFragment(getString(R.string.optional_request_for_signature));
    }
    public void onClickOptionalRequestForSignatureAndIdentification() {
        startWebViewFragment(getString(R.string.optional_request_for_signature_and_identification));
    }
    public void onClickOptionalFailingTransactionNoReceipt() {
        startWebViewFragment(getString(R.string.optional_failing_transaction_no_receipt));
    }
    public void onClickOptionalSplitPayment() {
        startWebViewFragment(getString(R.string.optional_split_payment));
    }

    private void startWebViewFragment(String urlText) {
        Bundle bundle = new Bundle();
        bundle.putString("url", getUrl(urlText));
        getParentFragmentManager()
                .beginTransaction()
                .addToBackStack("AttendedCertificationTestsWebViewFragment")
                .add(R.id.fragment_container_view, AttendedCertificationTestsWebViewFragment.class, bundle)
                .commit();
    }

    private String getUrl(String urlText) {
        URLSpan[] urls = Html.fromHtml(urlText).getSpans(0, urlText.length(), URLSpan.class);
        return urls[0].getURL();
    }
}
