package demo.mapi.ccv.eu.mapi_demo.activities;

import android.os.Bundle;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import demo.mapi.ccv.eu.mapi_demo.AndroidLogger;
import demo.mapi.ccv.eu.mapi_demo.R;
import eu.ccvlab.mapi.api.TerminalDiscoveryService;
import eu.ccvlab.mapi.core.api.TerminalDiscoveryApi;
import eu.ccvlab.mapi.core.api.response.delegate.TerminalDiscoveryDelegate;
import eu.ccvlab.mapi.core.api.response.result.Error;
import eu.ccvlab.mapi.core.logging.MPALogging;
import eu.ccvlab.mapi.core.terminal.ExternalTerminal;

import java.util.ArrayList;
import java.util.List;

public class TerminalDiscoveryActivity extends AppCompatActivity {
    private List<ExternalTerminal> externalTerminals;
    private final TerminalDiscoveryApi terminalDiscoveryService = new TerminalDiscoveryService();

    TextView resultTextView;
    ProgressBar progressBar;
    Button searchAllTerminalsButton;
    Button searchLocalTerminalsOnlyButton;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.terminal_discovery_activity);
        resultTextView = findViewById(R.id.terminal_discovery_output);
        progressBar = findViewById(R.id.loadingIndicator);
        searchAllTerminalsButton = findViewById(R.id.terminal_discovery_search_all_terminals_button);
        searchLocalTerminalsOnlyButton = findViewById(R.id.terminal_discovery_search_local_terminals_only_button);
        findViewById(R.id.terminal_discovery_search_all_terminals_button).setOnClickListener((View view) -> onClickTerminalDiscoverySearchAllTerminals());
        findViewById(R.id.terminal_discovery_search_local_terminals_only_button).setOnClickListener((View view) -> onClickTerminalDiscoverySearchLocalTerminalsOnly());
        findViewById(R.id.terminal_discovery_abort_button).setOnClickListener((View view) -> onClickAbort());
        resultTextView.setMovementMethod(new ScrollingMovementMethod());
        MPALogging.addLogger(new AndroidLogger("TerminalDiscoveryActivity"));
    }

    public void onClickTerminalDiscoverySearchAllTerminals() {
        setupForNewTerminalSearch();
        startTerminalDiscovery(false);
    }

    public void onClickTerminalDiscoverySearchLocalTerminalsOnly() {
        setupForNewTerminalSearch();
        startTerminalDiscovery(true);
    }

    private void setupForNewTerminalSearch() {
        externalTerminals = new ArrayList<>();
        clearResultTextView();
        showProgressBar();
    }

    public void onClickAbort() {
        terminalDiscoveryService.abortTerminalDiscovery();
    }

    private void clearResultTextView() {
        resultTextView.setText("");
    }

    private void startTerminalDiscovery(boolean onlySearchForLocalTerminal) {

        terminalDiscoveryService.automaticTerminalDiscovery(new TerminalDiscoveryDelegate() {
            @Override
            public void onComplete(List<ExternalTerminal> terminals) {
                for (ExternalTerminal terminal : terminals) {
                    if (!externalTerminals.contains(terminal)) {
                        externalTerminals.add(terminal);
                    }
                }
                printTerminals();
                hideProgressBar();
            }

            @Override
            public void onNextTerminal(ExternalTerminal terminal) {
                externalTerminals.add(terminal);
                printTerminals();
            }

            @Override
            public void onError(Error error) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        resultTextView.append(error.mapiError().description());
                        hideProgressBar();
                    }
                });
            }
        }, onlySearchForLocalTerminal);
    }

    private void printTerminals() {
        clearResultTextView();
        for (ExternalTerminal terminal : externalTerminals) {
            resultTextView.append(terminal.toString());
            resultTextView.append("\n");
            resultTextView.append("\n");
            resultTextView.append("==================================");
            resultTextView.append("\n");
            resultTextView.append("\n");

        }
    }

    private void showProgressBar() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressBar.setVisibility(View.VISIBLE);
                searchAllTerminalsButton.setVisibility(View.GONE);
                searchLocalTerminalsOnlyButton.setVisibility(View.GONE);
            }
        });
    }

    private void hideProgressBar() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressBar.setVisibility(View.GONE);
                searchAllTerminalsButton.setVisibility(View.VISIBLE);
                searchLocalTerminalsOnlyButton.setVisibility(View.VISIBLE);
            }
        });
    }
}
