package demo.mapi.ccv.eu.mapi_demo.activities;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.Insets;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;

import demo.mapi.ccv.eu.mapi_demo.R;
import demo.mapi.ccv.eu.mapi_demo.activities.attended.AttendedTerminalActivity;
import demo.mapi.ccv.eu.mapi_demo.activities.unattended.UnAttendedTerminalActivity;
import eu.ccvlab.api_android.MAPI;

public class MainActivity extends AppCompatActivity {
    Toolbar toolbar;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        setSupportActionBar(toolbar);
        WindowCompat.setDecorFitsSystemWindows(this.getWindow(), false);
        applyEdgeToEdgeOnRV(findViewById(R.id.root_layout));
        //CCV logger which gives us more insight so we can improve this demo-app
        MAPI.initialize(this);
        toolbar = findViewById(R.id.toolbar);
        findViewById(R.id.attended_terminal_activity_button).setOnClickListener((View view) -> clickedOnAttendedTerminalActivityButton());
        findViewById(R.id.unattended_terminal_activity_button).setOnClickListener((View view) -> clickedOnUnAttendedTerminalActivityButton());
        findViewById(R.id.terminal_discovery_activity_button).setOnClickListener((View view) -> clickedOnTerminalDiscoveryActivityButton());
        findViewById(R.id.barcode_scanner).setOnClickListener((View view) -> clickedOnBarcodeScannerActivityButton());
        findViewById(R.id.reboot_button).setOnClickListener((View view) -> clickedOnRebootActivityButton());
    }

    public void applyEdgeToEdgeOnRV(View rootView) {
        ViewCompat.setOnApplyWindowInsetsListener(rootView, new OnApplyWindowInsetsListener() {
            @NonNull
            @Override
            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat windowInsets) {
                Insets bars = windowInsets.getInsets(WindowInsetsCompat.Type.systemBars());
                // Apply insets
                v.setPadding(
                        bars.left,
                        bars.top,
                        bars.right,
                        bars.bottom
                );
                return windowInsets;
            }
        });
    }

    public void clickedOnAttendedTerminalActivityButton() {
        Intent intent = new Intent(this, AttendedTerminalActivity.class);
        startActivity(intent);
    }

    public void clickedOnUnAttendedTerminalActivityButton() {
        Intent intent = new Intent(this, UnAttendedTerminalActivity.class);
        startActivity(intent);
    }

    public void clickedOnTerminalDiscoveryActivityButton() {
        Intent intent = new Intent(this, TerminalDiscoveryActivity.class);
        startActivity(intent);
    }

    public void clickedOnBarcodeScannerActivityButton() {
        Intent intent = new Intent(this, BarcodeScannerActivity.class);
        startActivity(intent);
    }

    public void clickedOnRebootActivityButton() {
        Intent intent = new Intent(this, RebootActivity.class);
        startActivity(intent);
    }

}
