package demo.mapi.ccv.eu.mapi_demo;

/**
 * Maps the state of the MAPI demo app.
 * State is stored upon change and retrieved when the app is relaunched.
 */
public class MapiDemoState {
    String selectedOpiProtocol = "OPI-DE";
    final ProtocolState opiNl = new ProtocolState();
    final ProtocolState opiDe = new ProtocolState();
    final ProtocolState opiCh = new ProtocolState();

    class ProtocolState {
        Boolean singleSocket = true;
        String transactionId;
        String receiptNumber;
        Integer referenceNumber;
        String amount = "9.99";
        String unAttendedAmount = "9.99";
        String unAttendedMinimumAmount = "2.00";
        String unAttendedTotalAmount = "50.00";
        String port;
        String compatibilityPort;
        @SuppressWarnings("PMD.AvoidUsingHardCodedIP")
        String hostname = "127.0.0.1";
        @SuppressWarnings("PMD.AvoidUsingHardCodedIP")
        String unAttendedHostname = "127.0.0.1";
        String currency = "EUR";
        String terminalMode = "Attended terminal";
        String deliveryBoxResult = "DeliveryBox Success";
        String previousPaymentId;
        boolean restApi = false;
        String myCCVShopLocationId;
    }

    public MapiDemoState() {
        this.opiNl.port = "4100";
        this.opiNl.compatibilityPort = "4102";
        this.opiDe.port = "30002";
        this.opiDe.compatibilityPort = "30007";
        this.opiCh.port = "4100";
        this.opiCh.compatibilityPort = "4102";
    }

    public String getTransactionId(String protocol) {
        return selectState(protocol).transactionId;
    }

    public void setTransactionId(String protocol, String transactionId) {
        selectState(protocol).transactionId = transactionId;
    }

    public String getReceiptNumber(String protocol) {
        return selectState(protocol).receiptNumber;
    }

    public void setReceiptNumber(String protocol, String receiptNumber) {
        selectState(protocol).receiptNumber = receiptNumber;
    }

    public Integer getReferenceNumber(String protocol) {
        return selectState(protocol).referenceNumber;
    }

    public void setReferenceNumber(String protocol, Integer referenceNumber) {
        selectState(protocol).referenceNumber = referenceNumber;
    }

    public String getAmount(String protocol) {
        return selectState(protocol).amount;
    }

    public void setAmount(String protocol, String amount) {
        selectState(protocol).amount = amount;
    }

    public String getHostname(String protocol) {
        return selectState(protocol).hostname;
    }

    public void setHostname(String protocol, String hostname) {
        selectState(protocol).hostname = hostname;
    }

    public String getUnAttendedHostname(String protocol) {
        return selectState(protocol).unAttendedHostname;
    }

    public void setUnAttendedHostname(String protocol, String unAttendedHostname) {
        selectState(protocol).unAttendedHostname = unAttendedHostname;
    }

    public String getUnAttendedAmount(String protocol) {
        return selectState(protocol).unAttendedAmount;
    }

    public void setUnAttendedAmount(String protocol, String unAttendedAmount) {
        selectState(protocol).unAttendedAmount = unAttendedAmount;
    }

    public String getUnAttendedMinimumAmount(String protocol) {
        return selectState(protocol).unAttendedMinimumAmount;
    }

    public void setUnAttendedMinimumAmount(String protocol, String unAttendedMinimumAmount) {
        selectState(protocol).unAttendedMinimumAmount = unAttendedMinimumAmount;
    }

    public String getUnAttendedTotalAmount(String protocol) {
        return selectState(protocol).unAttendedTotalAmount;
    }

    public void setUnAttendedTotalAmount(String protocol, String unAttendedTotalAmount) {
        selectState(protocol).unAttendedTotalAmount = unAttendedTotalAmount;
    }

    public String getTerminalMode(String protocol) {
        return selectState(protocol).terminalMode;
    }

    public void setTerminalMode(String protocol, String terminalMode) {
        selectState(protocol).terminalMode = terminalMode;
    }


    public void setDeliveryBoxResult(String protocol, String deliveryBoxResult) {
        selectState(protocol).deliveryBoxResult = deliveryBoxResult;
    }

    public String getDeliveryBoxResult(String protocol) {
        return selectState(protocol).deliveryBoxResult;
    }


    public String getPort(String protocol) {
        return selectState(protocol).port;
    }

    public void setPort(String protocol, String port) {
        selectState(protocol).port = port;
    }

    public String getCompatibilityPort(String protocol) {
        return selectState(protocol).compatibilityPort;
    }

    public void setCompatibilityPort(String protocol, String compatibilityPort) {
        selectState(protocol).compatibilityPort = compatibilityPort;
    }

    public boolean isSingleSocket(String protocol) {
        Boolean singleSocket = selectState(protocol).singleSocket;
        return singleSocket == null ? true : singleSocket;
    }

    public void setSingleSocket(String protocol, boolean singleSocket) {
        selectState(protocol).singleSocket = singleSocket;
    }

    public void setCurrency(String protocol, String currency) {
        selectState(protocol).currency = currency;
    }

    public String getCurrency(String protocol) {
        return selectState(protocol).currency;
    }

    public String selectedOpiProtocol() {
        return selectedOpiProtocol;
    }

    public void selectedOpiProtocol(String selectedOpiProtocol) {
        this.selectedOpiProtocol = selectedOpiProtocol;
    }

    public void setPreviousPaymentId(String protocol, String previousPaymentId) {
        selectState(protocol).previousPaymentId = previousPaymentId;
    }

    public String getPreviousPaymentId(String protocol) {
        return selectState(protocol).previousPaymentId;
    }

    public void setRestApi(String protocol, boolean restApi) {
        selectState(protocol).restApi = restApi;
    }

    public boolean getRestApi(String protocol) {
        return selectState(protocol).restApi;
    }

    public void setMyCCVShopLocationId(String protocol, String myCCVShopLocationId) {
        selectState(protocol).myCCVShopLocationId = myCCVShopLocationId;
    }

    public String getMyCCVShopLocationId(String protocol) {
        return selectState(protocol).myCCVShopLocationId;
    }

    public ProtocolState selectState(String protocol) {
        switch (protocol) {
            case "OPI-DE":
                return this.opiDe;
            case "OPI-CH":
                return this.opiCh;
            case "OPI-NL":
            default:
                return this.opiNl;
        }
    }

}
