package demo.mapi.ccv.eu.mapi_demo;

public enum Flow {
    PAYMENT("Payment"),
    REFUND("Refund"),
    VOID("Void"),
    VOID_ANY("Void Any"),
    CARD_NOT_PRESENT_VOID_ANY("Card Not Present Void Any"),
    EXTERNAL_VOID("External Void"),
    ABORT("Abort"),
    SILENT_ABORT("Silent Abort"),
    REPEAT_LAST_PAYMENT("Repeat Last Payment"),
    REPEAT_LAST_SERVICE_MESSAGE("Repeat Last Service Message"),
    RETRIEVE_LAST_TICKET("Retrieve Last Ticket"),
    PERFORM_PERIOD_CLOSING("Perform Period Closing"),
    TICKET_REPRINT_PERIOD_CLOSING("Ticket Reprint Period Closing"),
    TRANSACTION_OVERVIEW("Transaction Overview"),
    STATUS("Status"),
    INITIALISATION("Initialisation"),
    CARD_READER_STATUS("Card Reader Status"),
    CARD_READ("Card Read"),
    CARD_READ_SECUREID("Card Read SecureID"),
    PAYMENT_AFTER_CARD_READ("Payment After Card Read"),
    ABORT_ON_NEW_CONNECTION("Abort on new connection"),
    SHOW_MENU("Show menu"),
    CARD_RESERVATION("Card Reservation"),
    SALES_AFTER_RESERVATION("Sale After Reservation"),
    CARD_NOT_PRESENT_SALES_AFTER_RESERVATION("Card Not Present Sale After Reservation"),
    RESERVATION_ADJUSTMENT("Reservation adjustment"),
    RESERVATION_ADJUSTMENT_NO_CARD_PRESENT("Reservation adjustment no card present"),
    CALLTMS("CallTMS"),
    DIAGNOSIS("Diagnosis"),
    EMV_DIAGNOSIS("Emv Diagnosis"),
    CONFIGURATION_DIAGNOSIS("Configuration Diagnosis"),
    FACTORY_RESET("Factory reset"),
    RESET_TO_FACTORY_SETTINGS("Reset to factory settings"),
    SERVICE_MENU("Service Menu"),
    OAM_SERVER_APPLICATIONS("OAM Server Applications"),
    DISPENSER_DELIVERED_GOODS("Dispenser delivered goods"),
    DISPENSER_NOT_DELIVERED_GOODS("Dispenser not delivered goods"),
    CONFIG_DATA("Config Data"),
    RECOVER_PAYMENT("Recover payment"),
    RECOVER_PAYMENT_CUT_PREVIOUS_CONNECTION("Recover payment, cut previous connection"),
    CARD_CIRCUITS("Card Circuits"),
    AUTHORISATION_BY_VOICE("Authorisation By Voice"),
    READ_UID("Read UID"),
    FLEXO("Flexo"),
    TAXFREE("Taxfree"),
    MOBILE_PHONE_PREPAID("Mobile Phone Prepaid"),
    CHECK_PASSWORD("Check Password"),
    ELME_VERSION_INFO("Elme Version Info"),
    PREAUTHORIZATION("PreAuthorization"),
    EXTENDED_PREAUTHORIZATION("Extended PreAuthorization"),
    FINANCIAL_ADVICE("Financial Advice"),
    EXTENDED_FINANCIAL_ADVICE("Extended Financial Advice"),
    GIFT_CARD_BALANCE("Gift-Card Balance"),
    GIFT_CARD_ACTIVATION("Gift-Card Activation"),
    ACTIVATE_TERMINAL("Activate Terminal"),
    STARTUP("Startup"),
    TOKEN("Token"),
    REFUND_WITH_TOKEN("Refund with token"),
    CARD_DETECTION("Card Detection"),
    ONLINE_AGENT_FLEXO("Online Agent Flexo"),
    LOGIN("Login");

    private String description;

    Flow(String description) {
        this.description = description;
    }

    public static Flow get(String name) {
        for (Flow flow : Flow.values()) {
            if (flow.description.equalsIgnoreCase(name))
                return flow;
        }
        return null;
    }

    @Override
    public String toString() {
        return "Flow{" +
                "name='" + description + '\'' +
                '}';
    }

    public String description() {
        return description;
    }
}
