package demo.mapi.ccv.eu.mapi_demo;


import eu.ccvlab.mapi.core.api.response.delegate.PaymentDelegate;
import eu.ccvlab.mapi.core.api.response.delegate.TerminalDelegate;
import eu.ccvlab.mapi.core.api.response.delegate.TokenDelegate;
import eu.ccvlab.mapi.core.payment.CardReadDelegate;
import eu.ccvlab.mapi.core.payment.CardReaderStatusDelegate;

public interface DelegationFactory {
    /**
     * Creates an {@link TerminalDelegate}, the delegate will merely log actions and mention the provided context
     *
     * @param context          The context for which messages will be logged
     * @return Logging delegate
     */
    TerminalDelegate createPaymentAdministrationDelegate(String context);

    /**
     * Creates an {@link PaymentDelegate}, the delegate will merely log actions and mention the provided context
     *
     * @param context The context for which messages will be logged
     * @return Logging delegate
     */
    PaymentDelegate createPaymentDelegate(String context);

    /**
     * Creates an {@link CardReaderStatusDelegate}, the delegate will merely log actions and mention the provided context
     *
     * @param context The context for which messages will be logged
     * @return Logging delegate
     */
    CardReaderStatusDelegate createCardReaderStatusDelegate(String context);

    /**
     * Creates an {@link CardReadDelegate}, the delegate will merely log actions and mention the provided context
     *
     * @param context The context for which messages will be logged
     * @return Logging delegate
     */
    CardReadDelegate createCardReadDelegate(String context);

    /**
     * Creates an {@link TokenDelegate}, the delegate will merely log actions and mention the provided context
     *
     * @param context          The context for which messages will be logged
     * @return Logging delegate
     */
    TokenDelegate createTokenDelegate(String context);
}
